package examples.localserver;

import javax.validation.Valid;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SignatureRequest")
public class SignatureRequest {
    @Valid
    @XmlElementWrapper(required = true)
    @XmlElement(name = "invoiceBody", required = true)
    @Documentation("Список ЭСФ, загружаемых в систему")
    private List<String> invoiceBodies = new ArrayList<>();

    @XmlElement(required = true)
    @Documentation("Весрия подписываемых ЭСФ")
    private String version;

    @XmlElement(required = true)
    @Documentation("Путь к сертификату на локальном компьютере")
    private String certificatePath;

    @XmlElement(required = true)
    @Documentation("Пароль к контейнеру с сертификатом")
    private String certificatePin;

    public List<String> getInvoiceBodies() {
        return invoiceBodies;
    }

    public void setInvoiceBodies(List<String> invoiceBodies) {
        this.invoiceBodies = invoiceBodies;
    }

    public String getCertificatePath() {
        return certificatePath;
    }

    public void setCertificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
    }

    public String getCertificatePin() {
        return certificatePin;
    }

    public void setCertificatePin(String certificatePin) {
        this.certificatePin = certificatePin;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}
